Ext.data.JsonP.sol_common_FileUtils({"tagname":"class","name":"sol.common.FileUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.FileUtils.js","href":"lib_sol.common.FileUtils.html#sol-common-FileUtils"}],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.0"],"elojc":true,"eloas":true,"eloix":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"bom","tagname":"property","owner":"sol.common.FileUtils","id":"property-bom","meta":{"private":true}},{"name":"contentTypeExtensions","tagname":"property","owner":"sol.common.FileUtils","id":"property-contentTypeExtensions","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"changeExtension","tagname":"method","owner":"sol.common.FileUtils","id":"method-changeExtension","meta":{}},{"name":"cleanPathParts","tagname":"method","owner":"sol.common.FileUtils","id":"method-cleanPathParts","meta":{}},{"name":"copyFile","tagname":"method","owner":"sol.common.FileUtils","id":"method-copyFile","meta":{}},{"name":"createTempDir","tagname":"method","owner":"sol.common.FileUtils","id":"method-createTempDir","meta":{}},{"name":"delete","tagname":"method","owner":"sol.common.FileUtils","id":"method-delete","meta":{}},{"name":"deleteFiles","tagname":"method","owner":"sol.common.FileUtils","id":"method-deleteFiles","meta":{}},{"name":"downloadDocument","tagname":"method","owner":"sol.common.FileUtils","id":"method-downloadDocument","meta":{}},{"name":"downloadDocuments","tagname":"method","owner":"sol.common.FileUtils","id":"method-downloadDocuments","meta":{}},{"name":"exists","tagname":"method","owner":"sol.common.FileUtils","id":"method-exists","meta":{}},{"name":"getExtension","tagname":"method","owner":"sol.common.FileUtils","id":"method-getExtension","meta":{}},{"name":"getExtensionFromPath","tagname":"method","owner":"sol.common.FileUtils","id":"method-getExtensionFromPath","meta":{}},{"name":"getName","tagname":"method","owner":"sol.common.FileUtils","id":"method-getName","meta":{}},{"name":"getParentPath","tagname":"method","owner":"sol.common.FileUtils","id":"method-getParentPath","meta":{}},{"name":"getTempDirPath","tagname":"method","owner":"sol.common.FileUtils","id":"method-getTempDirPath","meta":{}},{"name":"getTimeStampString","tagname":"method","owner":"sol.common.FileUtils","id":"method-getTimeStampString","meta":{}},{"name":"getUrlFromFilePath","tagname":"method","owner":"sol.common.FileUtils","id":"method-getUrlFromFilePath","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"loadToFileData","tagname":"method","owner":"sol.common.FileUtils","id":"method-loadToFileData","meta":{}},{"name":"makeDirectories","tagname":"method","owner":"sol.common.FileUtils","id":"method-makeDirectories","meta":{}},{"name":"readConfig","tagname":"method","owner":"sol.common.FileUtils","id":"method-readConfig","meta":{}},{"name":"readFileToObject","tagname":"method","owner":"sol.common.FileUtils","id":"method-readFileToObject","meta":{}},{"name":"readFileToString","tagname":"method","owner":"sol.common.FileUtils","id":"method-readFileToString","meta":{}},{"name":"readManifestFile","tagname":"method","owner":"sol.common.FileUtils","id":"method-readManifestFile","meta":{}},{"name":"removeExtension","tagname":"method","owner":"sol.common.FileUtils","id":"method-removeExtension","meta":{}},{"name":"rename","tagname":"method","owner":"sol.common.FileUtils","id":"method-rename","meta":{}},{"name":"sanitizeFilename","tagname":"method","owner":"sol.common.FileUtils","id":"method-sanitizeFilename","meta":{}},{"name":"saveFileData","tagname":"method","owner":"sol.common.FileUtils","id":"method-saveFileData","meta":{}},{"name":"writeConfigToFile","tagname":"method","owner":"sol.common.FileUtils","id":"method-writeConfigToFile","meta":{}},{"name":"writeObjectToFile","tagname":"method","owner":"sol.common.FileUtils","id":"method-writeObjectToFile","meta":{}},{"name":"writeStringArrayToFile","tagname":"method","owner":"sol.common.FileUtils","id":"method-writeStringArrayToFile","meta":{}},{"name":"writeStringToFile","tagname":"method","owner":"sol.common.FileUtils","id":"method-writeStringToFile","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.FileUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.FileUtils</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils' target='_blank'>lib_sol.common.FileUtils.js</a></div></pre><div class='doc-contents'><p>File utilities</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-bom' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-property-bom' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-property-bom' class='name expandable'>bom</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;\\uFEFF&quot;</code></p></div></div></div><div id='property-contentTypeExtensions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-property-contentTypeExtensions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-property-contentTypeExtensions' class='name expandable'>contentTypeExtensions</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{bmp: &quot;image/bmp&quot;, ico: &quot;image/x-ico&quot;, jpg: &quot;image/jpeg&quot;, png: &quot;image/png&quot;}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-changeExtension' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-changeExtension' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-changeExtension' class='name expandable'>changeExtension</a>( <span class='pre'>file, extension</span> ) : File<span class=\"signature\"></span></div><div class='description'><div class='short'>Change the extension of a file. ...</div><div class='long'><p>Change the extension of a file.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>file</span> : java.io.File<div class='sub-desc'><p>Source file</p>\n</div></li><li><span class='pre'>extension</span> : String<div class='sub-desc'><p>New file extension</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>File</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-cleanPathParts' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-cleanPathParts' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-cleanPathParts' class='name expandable'>cleanPathParts</a>( <span class='pre'>pathPartsArr, replacement</span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Clean path parts in a given array ...</div><div class='long'><p>Clean path parts in a given array</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>pathPartsArr</span> : Array<div class='sub-desc'><p>Array of path parts</p>\n</div></li><li><span class='pre'>replacement</span> : String<div class='sub-desc'><p>Replacement string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'><p>Clean path parts array</p>\n</div></li></ul></div></div></div><div id='method-copyFile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-copyFile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-copyFile' class='name expandable'>copyFile</a>( <span class='pre'>srcFile, dstFile</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Copies a file ...</div><div class='long'><p>Copies a file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>srcFile</span> : java.io.File<div class='sub-desc'>\n</div></li><li><span class='pre'>dstFile</span> : java.io.File<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createTempDir' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-createTempDir' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-createTempDir' class='name expandable'>createTempDir</a>( <span class='pre'>params</span> ) : java.io.File<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a temporary directory ...</div><div class='long'><p>Creates a temporary directory</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>prefix</span> : String<div class='sub-desc'><p>Prefix</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.io.File</span><div class='sub-desc'><p>Temporary directory</p>\n</div></li></ul></div></div></div><div id='method-delete' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-delete' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-delete' class='name expandable'>delete</a>( <span class='pre'>file, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Deletes a file ...</div><div class='long'><p>Deletes a file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>file</span> : java.io.File|String<div class='sub-desc'><p>File or file path</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>quietly</span> : Boolean<div class='sub-desc'><p>Delete quietly</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-deleteFiles' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-deleteFiles' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-deleteFiles' class='name expandable'>deleteFiles</a>( <span class='pre'>config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Deletes files ...</div><div class='long'><p>Deletes files</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Config</p>\n<ul><li><span class='pre'>dirPath</span> : String<div class='sub-desc'><p>Directory path</p>\n</div></li><li><span class='pre'>prefix</span> : String<div class='sub-desc'><p>Prefix</p>\n</div></li><li><span class='pre'>suffix</span> : String<div class='sub-desc'><p>Suffix</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-downloadDocument' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-downloadDocument' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-downloadDocument' class='name expandable'>downloadDocument</a>( <span class='pre'>objId, dstDirPath</span> ) : File<span class=\"signature\"></span></div><div class='description'><div class='short'>Download file ...</div><div class='long'><p>Download file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>dstDirPath</span> : String<div class='sub-desc'><p>Destination directory path</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>File</span><div class='sub-desc'><p>Downloaded document;</p>\n</div></li></ul></div></div></div><div id='method-downloadDocuments' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-downloadDocuments' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-downloadDocuments' class='name expandable'>downloadDocuments</a>( <span class='pre'>objId, dstDirPath, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Download documents ...</div><div class='long'><p>Download documents</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Folder or object ID</p>\n</div></li><li><span class='pre'>dstDirPath</span> : String<div class='sub-desc'><p>Destination directory path</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>makeDstDirs</span> : Boolean (optional)<div class='sub-desc'><p>Make directories</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>cleanDstDir</span> : Boolean<div class='sub-desc'><p>Clean destination directory</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-exists' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-exists' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-exists' class='name expandable'>exists</a>( <span class='pre'>path</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns true if the path exists ...</div><div class='long'><p>Returns true if the path exists</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>path</span> : String<div class='sub-desc'><p>Path</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getExtension' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-getExtension' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-getExtension' class='name expandable'>getExtension</a>( <span class='pre'>file</span> ) : java.lang.String<span class=\"signature\"></span></div><div class='description'><div class='short'>Extracts the file extension from a File ...</div><div class='long'><p>Extracts the file extension from a File</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>file</span> : java.io.File<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.lang.String</span><div class='sub-desc'><p>The file extension</p>\n</div></li></ul></div></div></div><div id='method-getExtensionFromPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-getExtensionFromPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-getExtensionFromPath' class='name expandable'>getExtensionFromPath</a>( <span class='pre'>filePath</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Extracts the file extension from a path ...</div><div class='long'><p>Extracts the file extension from a path</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>filePath</span> : String<div class='sub-desc'><p>file path</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>File extension</p>\n</div></li></ul></div></div></div><div id='method-getName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-getName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-getName' class='name expandable'>getName</a>( <span class='pre'>file</span> ) : java.lang.String<span class=\"signature\"></span></div><div class='description'><div class='short'>Extracts the file name from a File (without the file extension) ...</div><div class='long'><p>Extracts the file name from a File (without the file extension)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>file</span> : java.io.File<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.lang.String</span><div class='sub-desc'><p>The name of the file</p>\n</div></li></ul></div></div></div><div id='method-getParentPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-getParentPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-getParentPath' class='name expandable'>getParentPath</a>( <span class='pre'>path</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the path of the parent ...</div><div class='long'><p>Returns the path of the parent</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>path</span> : java.io.File<div class='sub-desc'><p>Path</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTempDirPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-getTempDirPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-getTempDirPath' class='name expandable'>getTempDirPath</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the temp directory path ...</div><div class='long'><p>Returns the temp directory path</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Temp directory path</p>\n</div></li></ul></div></div></div><div id='method-getTimeStampString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-getTimeStampString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-getTimeStampString' class='name expandable'>getTimeStampString</a>( <span class='pre'>pattern</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a timestamp of the current time as string. ...</div><div class='long'><p>Returns a timestamp of the current time as string.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>pattern</span> : String<div class='sub-desc'><p>Timestamp pattern</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Timestamp as string</p>\n</div></li></ul></div></div></div><div id='method-getUrlFromFilePath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-getUrlFromFilePath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-getUrlFromFilePath' class='name expandable'>getUrlFromFilePath</a>( <span class='pre'>filePath</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the URL of a file ...</div><div class='long'><p>Returns the URL of a file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>filePath</span> : String<div class='sub-desc'><p>File path</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>URL</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-loadToFileData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-loadToFileData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-loadToFileData' class='name expandable'>loadToFileData</a>( <span class='pre'>filePath, contentType</span> ) : de.elo.ix.client.FileData<span class=\"signature\"></span></div><div class='description'><div class='short'>Loads a file to a FileData structure ...</div><div class='long'><p>Loads a file to a FileData structure</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>filePath</span> : String<div class='sub-desc'><p>File path</p>\n</div></li><li><span class='pre'>contentType</span> : String<div class='sub-desc'><p>Content type</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.FileData</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-makeDirectories' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-makeDirectories' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-makeDirectories' class='name expandable'>makeDirectories</a>( <span class='pre'>dir</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Makes directories ...</div><div class='long'><p>Makes directories</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dir</span> : java.io.File<div class='sub-desc'><p>Directory</p>\n</div></li></ul></div></div></div><div id='method-readConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-readConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-readConfig' class='name expandable'>readConfig</a>( <span class='pre'>filePath</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Reads a file into a string ...</div><div class='long'><p>Reads a file into a string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>filePath</span> : String<div class='sub-desc'><p>FilePath</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-readFileToObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-readFileToObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-readFileToObject' class='name expandable'>readFileToObject</a>( <span class='pre'>filePath, params</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Reads a file into an object ...</div><div class='long'><p>Reads a file into an object</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>filePath</span> : String<div class='sub-desc'><p>FilePath</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>encoding</span> : String<div class='sub-desc'><p>Encoding</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-readFileToString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-readFileToString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-readFileToString' class='name expandable'>readFileToString</a>( <span class='pre'>filePath, params</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Reads a file into a string ...</div><div class='long'><p>Reads a file into a string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>filePath</span> : String<div class='sub-desc'><p>FilePath</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>encoding</span> : String<div class='sub-desc'><p>Encoding</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-readManifestFile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-readManifestFile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-readManifestFile' class='name expandable'>readManifestFile</a>( <span class='pre'>filePath</span> ) : java.util.Map&lt;Object,Object&gt;<span class=\"signature\"></span></div><div class='description'><div class='short'>Reads a manifest file ...</div><div class='long'><p>Reads a manifest file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>filePath</span> : String<div class='sub-desc'><p>Manifest file path</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.util.Map&lt;Object,Object&gt;</span><div class='sub-desc'><p>Attributes</p>\n</div></li></ul></div></div></div><div id='method-removeExtension' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-removeExtension' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-removeExtension' class='name expandable'>removeExtension</a>( <span class='pre'>file</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Removes the extension of a file or file path ...</div><div class='long'><p>Removes the extension of a file or file path</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>file</span> : java.io.File|String<div class='sub-desc'><p>File or file path</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>File path without extension</p>\n</div></li></ul></div></div></div><div id='method-rename' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-rename' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-rename' class='name expandable'>rename</a>( <span class='pre'>path, newName</span> ) : java.io.File<span class=\"signature\"></span></div><div class='description'><div class='short'>Rename a file ...</div><div class='long'><p>Rename a file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>path</span> : String<div class='sub-desc'><p>Path</p>\n</div></li><li><span class='pre'>newName</span> : String<div class='sub-desc'><p>New file name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.io.File</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-sanitizeFilename' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-sanitizeFilename' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-sanitizeFilename' class='name expandable'>sanitizeFilename</a>( <span class='pre'>fileName, replacement</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Cleans the given file name so that the name contains only valid file name chars. ...</div><div class='long'><p>Cleans the given file name so that the name contains only valid file name chars.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fileName</span> : String<div class='sub-desc'><p>File name to clean</p>\n</div></li><li><span class='pre'>replacement</span> : String<div class='sub-desc'><p>Replacement string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Sanitized filename</p>\n</div></li></ul></div></div></div><div id='method-saveFileData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-saveFileData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-saveFileData' class='name expandable'>saveFileData</a>( <span class='pre'>fileData, filePath</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Save file data to file ...</div><div class='long'><p>Save file data to file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fileData</span> : de.elo.ix.client.FileData<div class='sub-desc'>\n</div></li><li><span class='pre'>filePath</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-writeConfigToFile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-writeConfigToFile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-writeConfigToFile' class='name expandable'>writeConfigToFile</a>( <span class='pre'>path, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Writes a configuation into a file ...</div><div class='long'><p>Writes a configuation into a file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>path</span> : String<div class='sub-desc'><p>Path</p>\n</div></li><li><span class='pre'>config</span> : String<div class='sub-desc'><p>Configuration object</p>\n</div></li></ul></div></div></div><div id='method-writeObjectToFile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-writeObjectToFile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-writeObjectToFile' class='name expandable'>writeObjectToFile</a>( <span class='pre'>obj, filePath</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Writes an object into a file ...</div><div class='long'><p>Writes an object into a file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj</span> : Object<div class='sub-desc'><p>Object</p>\n</div></li><li><span class='pre'>filePath</span> : String<div class='sub-desc'><p>File path</p>\n</div></li></ul></div></div></div><div id='method-writeStringArrayToFile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-writeStringArrayToFile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-writeStringArrayToFile' class='name expandable'>writeStringArrayToFile</a>( <span class='pre'>path, stringArray</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Writes a string into a file ...</div><div class='long'><p>Writes a string into a file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>path</span> : String<div class='sub-desc'><p>Path</p>\n</div></li><li><span class='pre'>stringArray</span> : String<div class='sub-desc'><p>String array</p>\n</div></li></ul></div></div></div><div id='method-writeStringToFile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.FileUtils'>sol.common.FileUtils</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-FileUtils-method-writeStringToFile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.FileUtils-method-writeStringToFile' class='name expandable'>writeStringToFile</a>( <span class='pre'>filePath, content, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Writes a string into a file ...</div><div class='long'><p>Writes a string into a file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>filePath</span> : String<div class='sub-desc'><p>File path</p>\n</div></li><li><span class='pre'>content</span> : String<div class='sub-desc'><p>Text content</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>bom</span> : Boolean<div class='sub-desc'><p>Add byte order mark</p>\n</div></li><li><span class='pre'>encoding</span> : Boolean (optional)<div class='sub-desc'><p>Encoding</p>\n<p>Defaults to: <code>UTF-8</code></p></div></li></ul></div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true,"singleton":true}});